unit fNonModalSearch;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, uEstSearchDialog, uEstSearchDialogAdo, uEstSearchDialogConst;

type
  TFrmNonModalSearch = class(TForm)
    esdNonModal: TEstSearchDialogAdo;
    btnSearchNonModal: TButton;
    mmoLimitedSearch: TMemo;
    chbInForeground: TCheckBox;
    Label1: TLabel;
    lbxCustomers: TListBox;
    chbMDIChild: TCheckBox;
    procedure btnSearchNonModalClick(Sender: TObject);
    procedure esdNonModalSelect(Sender: TObject);
    procedure esdNonModalClose(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmNonModalSearch: TFrmNonModalSearch;

implementation

{$R *.dfm}

procedure TFrmNonModalSearch.btnSearchNonModalClick(Sender: TObject);
begin

  // NL: Als de checkbox uitgeschakeld is, dan is er een dialog operationeel en
  // hoeft en niets met de checkbox gedaan te worden
  // EN: If the checkbox is unchecked, a dialog is operational and nothing needs
  // to be done to the checkbox
  if chbInForeground.Enabled then
  begin
    // NL: Schakel de checkbox uit want SendToBackOnSelect kan niet gewijzigd worden
    // tijdens het zoeken
    // EN: Uncheck the checkbox because SendToBackOnSelect cannot be changed
    // during a search operation
    chbInForeground.Enabled := False;

    // NL: De SearchStyle kan natuurlijk ook niet gewijzigd worden tijdens het zoeken
    // EN: Offcourse the SearchStyle can also not be changed during the search
    chbMDIChild.Enabled := False;

    // NL: Stel dialog in volgens checkboxen
    // EN: Setup dialog according to the checkboxes
    if chbMDIChild.Checked then
      esdNonModal.SearchStyle := ssMDIChild
    else
      esdNonModal.SearchStyle := ssNormal;
  end;

  // NL: Start het zoeken. Het resultaat van execute is niet interessant.
  // EN: Start searching. The search result is not important.
  esdNonModal.Execute;
end;

procedure TFrmNonModalSearch.esdNonModalSelect(Sender: TObject);
begin
  // NL: Vul de lijst van gevonden klanten aan met het geselecteerde resultaat
  // EN: Add the customer found to the list of customers found so far
  lbxCustomers.Items.Add(Format('%d - %s', [esdNonModal.ResultFieldAsInteger('custno'),
                                          esdNonModal.ResultFieldAsString('company')]));

  // NL: Zet focus op form indien van toepassing
  // EN: Set focus on form if applicable
  if not chbInForeground.Enabled then
  begin
    if esdNonModal.SearchStyle = ssMDIChild then
      BringToFront
    else
      Application.MainForm.BringToFront;
  end;
end;

procedure TFrmNonModalSearch.esdNonModalClose(Sender: TObject);
begin
  // NL: Het zoeken is afgelopen, zet de checkboxen weer aan
  // EN: The search is done, restore the checkboxes
  chbInForeground.Enabled := True;
  chbMDIChild.Enabled := True;
end;

procedure TFrmNonModalSearch.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

end.
